using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using VIRP.CRS.BO;
using VIRP.CRS.DAL;

namespace VIRP.CRS.BLL
{
	public static partial class WKF_CASEManager
	{
        #region Fields
        #endregion

        #region Constructors
        #endregion

        #region Properties
        #endregion

        #region Methods

        public static WKF_CASE GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            WKF_CASE objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetItem(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);

            return objReturn;
        }

        public static WKF_CASE GetItemByActivity(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            WKF_CASE objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetItemByActivity(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            return objReturn;
        }

        public static List<WKF_CASE> GetItemsByReferral(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 REFERRAL_ID)
        {
            List<WKF_CASE> objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetItemsByReferral(CURRENT_USER, CURRENT_REGISTRY_ID, REFERRAL_ID);

            return objReturn;
        }

        public static List<WKF_CASE> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE> objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetItems(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static LabOrderPatient GetPatientByActivityId(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ACTIVITY_ID)
        {
            LabOrderPatient objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetPatientByActivityId(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ACTIVITY_ID);

            return objReturn;
        }

        public static List<LabKitOrderPatientsBO> GetNewLabKitOrders(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 STD_INSTITUTION_ID, Int32 STD_WKFCASETYPE_ID)
        {
            List<LabKitOrderPatientsBO> objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetNewLabKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID, STD_INSTITUTION_ID, STD_WKFCASETYPE_ID);

            return objReturn;
        }

        public static List<LabKitOrderGroup> GetPatientsForNewKitOrders(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<LabKitOrderGroup> objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetPatientsForNewKitOrders(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE objSave)
        {
            Int32 objReturn = 0;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.Save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID)
        {
            Boolean objReturn = false;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.Delete(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID);

            return objReturn;
        }

        public static Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, WKF_CASE objDelete)
        {
            return Delete(CURRENT_USER, CURRENT_REGISTRY_ID, objDelete.WKF_CASE_ID);
        }

        public static List<WKF_CASE> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<WKF_CASE> objReturn = null;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.GetItemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID);

            return objReturn;
        }

        public static Boolean UpdateStatus(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 WKF_CASE_ID, Int32 STD_WKFCASESTS_ID)
        {
            Boolean objReturn = false;
            WKF_CASEDB objDB = new WKF_CASEDB();

            objReturn = objDB.UpdateStatus(CURRENT_USER, CURRENT_REGISTRY_ID, WKF_CASE_ID, STD_WKFCASESTS_ID);

            return objReturn;
        }

		#endregion
	}
}
